function systemObject()
{
	this.currentBattle = undefined;
	this.party = new Array();
	this.items = new Array();
	this.actions = new Array();
	this.money = 0;
	this.formation = "Standard";
	// Input stuff
	this.lastPress = 0;
	this.keyDelay = 100;
	this.accept = KEY_A;
	this.cancel = KEY_S;
	this.menu = KEY_D;
	this.etc = KEY_F;
	// Message stuff
	this.descriptionPos = 0;
	this.descriptionTime = 0;
	this.battleMessageSpeed = 2000;
	this.fieldMessageSpeed = 15;
	this.textColor = CreateColor(255, 255, 255);
	this.thoughtColor = CreateColor(160, 160, 160);
	// Window colors
	this.windowLeft = CreateColor(0, 40, 80, 128);
	this.windowRight = CreateColor(0, 40, 80, 0);
	// Sounds
	this.music = undefined; // Current music
	this.cursorMove = LoadSound("cursor_move.ogg");
	this.cursorCancel = LoadSound("cursor_cancel.ogg");
	this.bDigits = new Array(0, 0, 0, 0, 0, 0, 3, 6, 9, 12, 14, 15, 15, 16, 16, 16, 15, 15, 14, 12, 9, 6, 3, 0, 2, 4, 4, 5, 5, 5, 4, 4, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
}

var system = new systemObject();

function InitiateGame()
{
	SetUpdateScript("updateLoop()");
	SetRenderScript("drawLoop()");
	addItem("Potion", 5);
	BindKey(system.accept, "AcceptKey()", "");
	system.party[0] = Damizean;
	system.party[1] = Annika;
	system.party[2] = Lazaerin;
	system.party[3] = Richt;
	setFormation("Standard");
	system.money = 300;
}

function IsPress()
{
	if (system.lastPress + system.keyDelay < GetTime())
	{
		return true;
	}
	else
		return false;
}

function Press(sound)
{
	system.lastPress = GetTime();
	switch (sound)
	{
		case "error":
			break;
		case "cancel":
			break;
		default:
			playSound(system.cursorMove);
			break;
	}
}

function playSound(sound)
{
	if (sound.isPlaying())
	{
		sound.stop();
	}
	sound.play(false);
}

function random(min, max)
{
	return (Math.random() * (max - min)) + min;
}

function Elements()
{
	var element = new Array();
	element["fire"] = 1;
	element["ice"] = 1;
	element["lightning"] = 1;
	element["water"] = 1;
	element["earth"] = 1;
	element["wind"] = 1;
	element["holy"] = 1;
	element["shadow"] = 1;
	return element;
}

function Status()
{
	var status = new Array();
	status["poison"] = false;
	status["confuse"] = false;
	status["blind"] = false;
	status["silence"] = false;
	status["berserk"] = false;
	status["distraught"] = false;
	status["burn"] = false; // 2x damage as poison and damages MP as well
	status["wound"] = false; // Character is unconscious and unable to act
	status["haste"] = false; // Speed up!
	status["slow"] = false; // Speed down :(
	status["stop"] = false; // Cannot charge
	status["vanish"] = false; // Invisible creature
	status["aerial"] = false; // Flying creature
	status["thick"] = false; // Resistant to physical attacks
	status["resist"] = false; // Resistant to magic
	status["overflow"] = false; // Can do damage over 9999
	return status;
}

// Executes variable differently depending on type
function execute(variable)
{
	switch (typeof variable)
	{
		case "string":
			eval(variable);
			break;
		case "function":
			variable();
			break;
		case "undefined":
			break;
	}
}

// Some needed plot progression function
// Returns true if system.money is greater or equal to amount specified
function checkMoney(amount)
{
	if (system.money >= amount)
	{
		return true;
	}
	else
		return false;
}

// Checks to see if a character is in the current party
function checkCharacter(name)
{
	for (var i = 0; i < system.party.length; i ++)
	{
		if (system.party[i].name == name)
		{
			return true;
		}
	}
	return false;
}

function setFormation(name)
{
	var positions = new Array(8);
	var pos = 0;
	switch (name)
	{
		case "Standard":
			positions = new Array(290, 60, 290, 90, 290, 120, 290, 150);
			break;
	}
	for (var i = 0; i < system.party.length; i ++)
	{
		system.party[i].x = positions[pos];
		system.party[i].y = positions[pos + 1];
		pos += 2;
	}
}

// Removes an item from an array and returns a new array
function arrayRemove(item, array)
{
	var iarray = new Array();
	for (var i = 0; i < array.length; i ++)
	{
		if (i != item)
		{
			iarray[iarray.length] = array[i];
		}
	}
	return iarray;
}